%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function [angles] = compute_angles(coords);

x1=coords.x1;
x2=coords.x2;
x3=coords.x3;
y1=coords.y1;
y2=coords.y2;
y3=coords.y3;

a=sqrt((x1-x2)^2+(y1-y2)^2);
b=sqrt((x2-x3)^2+(y2-y3)^2);
c=sqrt((x1-x3)^2+(y1-y3)^2);

angles = zeros(1,3);

angles(1) = acos((b^2+c^2-a^2)/(2*b*c));
angles(2) = acos((c^2+a^2-b^2)/(2*c*a));
angles(3) = acos((a^2+b^2-c^2)/(2*a*b));

angles = (180/pi)*angles;
